<?php
 require_once 'assets/inc/Dbconfig.php';
 
 if(isset($_POST['submit']))
 {
  $headline  =  htmlspecialchars(stripslashes(ucfirst(@$_POST['heading'])));
  $imgFile = $_FILES['fileToUpload']['name'];
  $tmp_dir = $_FILES['fileToUpload']['tmp_name'];
  $imgSize = $_FILES['fileToUpload']['size'];
}  
  
  if(empty($headline)){
   $errMSG = "Please Enter headline.";
  }
  else if(empty($imgFile)) {
    $userpic = "";
  }
  else
  {
   $upload_dir = '../uploads/'; 
 
   $imgExt = strtolower(pathinfo($imgFile,PATHINFO_EXTENSION)); // get image extension
  
   $valid_extensions = array('jpeg', 'jpg', 'png', 'gif','pdf','xls','xlsx'); // valid extensions
  
   // rename uploading image
   $userpic = rand(1000,1000000).".".$imgExt;
    
   // allow valid image file formats
   if(in_array($imgExt, $valid_extensions)) {   
    // Check file size '5MB'
    if($imgSize < 10000000)    {
     move_uploaded_file($tmp_dir,$upload_dir.$userpic);
    }
    else{
     $errMSG = "Sorry, your file is too large.";
    }
   }
   else{
     $errMSG = "Sorry, only JPG, JPEG, PNG & GIF files are allowed.";  
    }
  }
  
  
  // if no error occured, continue ....
  if(!isset($errMSG))
  {
   $stmt = $DB_con->prepare('INSERT INTO online_notice(headline,userPic) VALUES(:head, :upic)');
   $stmt->bindParam(':head',$headline);
   $stmt->bindParam(':upic',$userpic);
   
   if($stmt->execute())
   {
    $successMSG = "new record succesfully inserted ...";
    header("location: view.php"); 
   }
   else
   {
    $errMSG = "error while inserting....";
   }
  }
 
?>
<?php require_once('assets/inc/header.php'); ?>
	<div class="container-fluid">
		<div class="row">
            <div class="col-md-3">
			     <?php require_once('assets/inc/sidebar.php'); ?>
            </div>
			<div class="col-md-8">
<form class="form-horizontal" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>" method="post" enctype="multipart/form-data">
  <fieldset>
    <legend>Notice Online</legend>
    <div class="form-group">
	    <div class="row">
	    	<div class="col-md-2"></div>
		    	<div class="col-lg-8">
		    		<?php if(isset($_GET['errMSG'])) 
            { 
              $errMSG = $_GET['errMSG'];
				      	echo '<div class="alert alert-dismissible alert-danger">
			  			  <strong>Error</strong>"'.$errMSG.'"</div>' ?> 
			  			  <?php } ?>
							<?php if(isset($_GET['successMSG'])) {
                $successMSG = $_GET['successMSG'];
						echo '<div class="alert alert-dismissible alert-success">
			  		  		<strong>done!</strong>"'.$successMSG.'"</div>'; ?> 
			  		  		<?php } 
			  		  			?>

				</div>
				<div class="col-md-2"></div>
		</div>
	</div>
    <div class="form-group">
      <label for="textArea" class="col-lg-2 control-label">Heading</label>
      <div class="col-lg-8">
        <textarea class="form-control" rows="3" name="heading"></textarea><grammarly-btn><div style="visibility: hidden; z-index: 2;" class="_9b5ef6-textarea_btn _9b5ef6-not_focused" data-grammarly-reactid=".0"><div class="_9b5ef6-transform_wrap" data-grammarly-reactid=".0.0"><div title="Protected by Grammarly" class="_9b5ef6-status" data-grammarly-reactid=".0.0.0">&nbsp;</div></div></div></grammarly-btn>
        <br />
      </div>
    </div>
    
	<div class="form-group">
		<div class="col-lg-8 col-lg-offset-2">
			<label>Upload the File</label>
			<input type="file" name="fileToUpload" accept="image/*" id="BSbtninfo">
	 	</div>
	 	<div class="col-lg-2 col-md-2"></div>
	</div>
    <div class="form-group">
      <div class="col-lg-10 col-lg-offset-2">
        <button type="reset" class="btn btn-default">Cancel</button>
        <button type="submit" name="submit" class="btn btn-primary">Submit</button>
      </div>
    </div>
  </fieldset>
</form>
			</div>
		</div>
<?php require_once('assets/inc/footer.php'); ?>
